################################################################################
# Function fish.proc.four():                                                   #
# Analog fish.proc.three(): If a gene occurs in multiple gene functional       #
# groups, the gene is kept in the largest functional group (i.e. the group     #
# with the largest number of genes) and ignored in the other ones. Be careful: #
# If the largest gene functional group is not unique, one of these should be   #
# chosen by chance.                                                            #
#  Input: 1. a gene list 'genes'; each entry itsself is a list of pathway      #
#            names (if a gene is not in any pathway, the entry is 'NA')        #
#         2. the data matrix x                                                 #
#         3. a pathway list 'genesINpath', each entry itself is a list of gene #
#            names included in the respective pathway                          #
#  Output: a vector of gene names with the property from above                 #
################################################################################

whichMAX <- function(vec) {
            ifelse( sum(max(vec)==vec)==1, which.max(vec), sample(which(vec==max(vec)),1) )
            }

fish.proc.four() <- function(genes,x,genesINpath){

                    annotx <- genes[colnames(x)]
                    out    <- colnames(x)
                    l      <- sapply(annotx,length) == 1
                    names(out)[l]  <- unlist(annotx[l])
                    multiplelist   <- annotx[!l]
                    names(out)[!l] <- sapply(multiplelist, function(ll) ll[whichMAX(sapply(genesINpath[ll],length))] )
                    return(out)
                    }